﻿/**
 * Options for alive with Alt markers.
 * Настройки маркеров для живых с Alt.
 */
{
"def": {
     // Damage text definition.
     // Шаблон всплывающего урона.
          "damageText": {                     //  всплывающий урон
            "visible": true,                  //  false - не отображать
            "x": 0,                           //  положение по оси X
            "y": -100,                        //  положение по оси Y
            "alpha": 100,                     //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
            "color": null,                    //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
            "font": {                         //  параметры шрифта
              "name": "$FieldFont",           //  название
              "size": 15,                     //  размер
              "align": "center",              //  выравнивание текста (left, center, right)
              "bold": true,                   //  обычный (false) или жирный (true)
              "italic": false                 //  обычный (false) или курсив (true)
            },
            "shadow": {                       //  параметры тени
              "alpha": 100,                   //  прозрачность
              "color": "0x000000",            //  цвет
              "angle": 45,                    //  угол смещения
              "strength": 200,                //  интенсивность
              "distance": 0,                  //  дистанция смещение
              "size": 2                       //  размер
            },
            "speed": 2,                       //  время отображения отлетающего урона
            "maxRange": 60,                   //  расстояние, на которое отлетает урон
      "damageMessage": "{{dmg}}"              //  текст при обычном уроне (см. описание макросов в readme-ru.txt)
  },
     // Text fields definition.
     // Шаблон текстовых полей.
          "textFields": [
        // Название танка
            {
              "name": "vehicle",              //  название текстового поля, ни на что не влияет
              "visible": true,                //  false - не отображать
              "x": 0,                         //  положение по оси X
              "y": "{{xvm-stat?-55|-41}}",                       //  положение по оси Y
              "alpha": 100,                   //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
              "color": null,                  //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
              "font": {                       //  параметры шрифта
                "name": "$FieldFont",         //  название
                "size": 14,                   //  размер
                "align": "center",            //  выравнивание текста (left, center, right)
                "bold": true,                 //  обычный (false) или жирный (true)
                "italic": false               //  обычный (false) или курсив (true)
              },
              "shadow": {                     //  параметры тени
                "alpha": 100,                 //  прозрачность
                "color": "0x000000",          //  цвет
                "angle": 45,                  //  угол смещения
                "strength": 200,              //  интенсивность
                "distance": 0,                //  дистанция смещение
                "size": 1                     //  размер
              },
              "format": "{{rlevel}} {{vehicle}}"  //  формат текста. См. описание макросов в readme-ru.txt
            },
        // Рейтинг и количество боев
            {
              "name": "rating, battles",  //  название текстового поля, ни на что не влияет
              "visible": true,                //  false - не отображать
              "x": 0,                         //  положение по оси X
              "y": -40,                       //  положение по оси Y
              "alpha": 100,                   //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
              "color": "0xEDEDED",            //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
              "font": {                       //  параметры шрифта
                "name": "$FieldFont",         //  название
                "size": 13,                   //  размер
                "align": "center",            //  выравнивание текста (left, center, right)
                "bold": true,                 //  обычный (false) или жирный (true)
                "italic": false               //  обычный (false) или курсив (true)
              },
              "shadow": {                     //  параметры тени
                "alpha": 100,                 //  прозрачность
                "color": "0x000000",          //  цвет
                "angle": 45,                  //  угол смещения
                "strength": 200,              //  интенсивность
                "distance": 0,                //  дистанция смещение
                "size": 1                     //  размер
              },
              "format": ${ "_rating.xc": "markersAliveExtended.formatRating" }  //  формат текста. См. описание макросов в readme-ru.txt
            },
            // Имя игрока
            {
              "name": "nick",                 //  название текстового поля, ни на что не влияет
              "visible": true,                //  false - не отображать
              "x": 0,                         //  положение по оси X
              "y": "{{xvm-stat?-71|-57}}",                       //  положение по оси Y
              "alpha": 100,                   //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
              "color": null,                  //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
              "font": {                       //  параметры шрифта
                "name": "$FieldFont",         //  название
                "size": 15,                   //  размер
                "align": "center",            //  выравнивание текста (left, center, right)
                "bold": true,                 //  обычный (false) или жирный (true)
                "italic": false               //  обычный (false) или курсив (true)
              },
              "shadow": {                     //  параметры тени
                "alpha": 100,                 //  прозрачность
                "color": "0x000000",          //  цвет
                "angle": 45,                  //  угол смещения
                "strength": 200,              //  интенсивность
                "distance": 0,                //  дистанция смещение
                "size": 1                     //  размер
              },
              "format": "{{name%.13s~..}} <font size='14' color='#FFCC66'>{{clannb}}</font>"  //  формат текста. См. описание макросов в readme-ru.txt
            },
            // Процент оставшегося здоровья
            {
              "name": "hp ratio",             //  название текстового поля, ни на что не влияет
              "visible": true,                //  false - не отображать
              "x": 0,                         //  положение по оси X
              "y": -20,                       //  положение по оси Y
              "alpha": 100,                   //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
              "color": "0xEDEDED",            //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
              "font": {                       //  параметры шрифта
                "name": "$FieldFont",         //  название
                "size": 13,                   //  размер
                "align": "center",            //  выравнивание текста (left, center, right)
                "bold": true,                 //  обычный (false) или жирный (true)
                "italic": false               //  обычный (false) или курсив (true)
              },
              "shadow": {                     //  параметры тени
                "alpha": 100,                 //  прозрачность
                "color": "0x000000",          //  цвет
                "angle": 45,                  //  угол смещения
                "strength": 200,              //  интенсивность
                "distance": 0,                //  дистанция смещение
                "size": 1                     //  размер
              },
               "format": "{{hp-ratio}}% / {{hp-max}}"  //  формат текста. См. описание макросов в readme-ru.txt
            },
            // Процент побед
            {
              "name": "global win ratio",     //  название текстового поля, ни на что не влияет
              "visible": true,
              "x": 44,
              "y": -29,
              "alpha": 100,
              "color": "0xEDEDED",
              "font": {
                "name": "$FieldFont",
                "size": 13,
                "align": "center",
                "bold": true,
                "italic": false
              },
              "shadow": {
                "alpha": 100,
                "color": "0x000000",
                "angle": 45,
                "strength": 200,
                "distance": 0,
                "size": 1
              },
              "format": "<font size='{{xvm-stat?13|0}}' color='{{c:rating}}'>{{rating%d~%|--%}}</font>"
            },
            // Процент побед на танке
            {
              "name": "vehicle win ratio",    //  название текстового поля, ни на что не влияет
              "visible": true,
              "x": -44,
              "y": -29,
              "alpha": 100,
              "color": "0xEDEDED",
              "font": {
                "name": "$FieldFont",
                "size": 13,
                "align": "center",
                "bold": true,
                "italic": false
              },
              "shadow": {
                "alpha": 100,
                "color": "0x000000",
                "angle": 45,
                "strength": 200,
                "distance": 0,
                "size": 1
              },
              "format": "<font size='{{xvm-stat?13|0}}' color='{{c:t-rating}}'>{{t-rating%d~%|--%}}</font>"
            }
        ]
 },
  "ally": {
          "healthBar": {                      //  индикатор здоровья
            "visible": true,                  //  false - не отображать
            "x": -31,                         //  положение по оси X
            "y": -37,                         //  положение по оси Y
            "alpha": 100,                     //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
            "color": null,                    //  цвет основной (допускается использование динамического цвета, см. readme-ru.txt)
            "lcolor": null,                   //  цвет дополнительный (для градиента)
            "width": 60,                      //  ширина полосы здоровья
            "height": 3,                      //  высота полосы здоровья
            "border": {                       //  параметры подложки и рамки
              "alpha": 30,                    //  прозрачность
              "color": "0x000000",            //  цвет
              "size": 1                       //  размер рамки
            },
            "fill": {                         //  параметры оставшегося здоровья
              "alpha": 70                     //  прозрачность
            },                                //
            "damage": {                       //  параметры анимации отнимаемого здоровья
              "alpha": 80,                    //  прозрачность
              "color": "0xFFFFFF",            //  цвет
              "fade": 1                       //  время затухания в секундах
            }
          },
          "vehicleIcon": {                    //  иконка типа танка (тт/ст/лт/пт/арта)
            "visible": true,                  //  false - не отображать
            "showSpeaker": false,             //  true - Показывать спикер даже если visible=false
            "x": 0,                           //  положение по оси X
            "y": -16,                         //  положение по оси Y
            "alpha": 100,                     //  прозрачность
            "color": null,                    //  цвет (в данный момент не используется)
            "maxScale": 100,                  //  максимальный масштаб (по умолчанию 100)
            "scaleX": 0,                      //  смещение по оси X (?)
            "scaleY": 16,                     //  смещение по оси Y (?)
            "shadow": {                       //  параметры тени
              "alpha": 100,                   //  прозрачность
              "color": "0x000000",            //  цвет
              "angle": 45,                    //  угол смещения
              "strength": 120,                //  интенсивность
              "distance": 0,                  //  дистанция смещение
              "size": 1                       //  размер
            }
          },
          "contourIcon": {                    //  иконка танка
            "visible": false,                 //  false - не отображать
            "x": 6,                           //  положение по оси X
            "y": -65,                         //  положение по оси Y
            "alpha": 100,                     //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
            "color": null,                    //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
            "amount": 0                       //  интенсивность цвета от 0 до 100. По умолчанию 0, т.е. выключено.
          },
          "clanIcon": {                       //  иконка игрока/клана
            "visible": false,                 //  false - не отображать
            "x": 0,                           //  положение по оси X
            "y": -67,                         //  положение по оси Y
            "w": 16,                          //  ширина
            "h": 16,                          //  высота
            "alpha": 100                      //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
          },
          "actionMarker": {                   //  маркеры "Нужна помощь" и "Атакую"
            "visible": true,                  //  false - не отображать
            "x": 0,                           //  положение по оси X
            "y": -100,                        //  положение по оси Y
            "alpha": 100                      //  прозрачность
          },
          "levelIcon": {                      //  уровень танка
            "visible": false,                 //  false - не отображать
            "x": 0,                           //  положение по оси X
            "y": -21,                         //  положение по оси Y
            "alpha": 100                      //  прозрачность
          },
          "damageText": {                     //  всплывающий урон
            "visible": true,                  //  false - не отображать
            "x": 0,                           //  положение по оси X
            "y": -100,                        //  положение по оси Y
            "alpha": 100,                     //  прозрачность (допускается использование динамической прозрачности, см. readme-ru.txt)
            "color": "0xFFFFFF",              //  цвет (допускается использование динамического цвета, см. readme-ru.txt)
            "font": {                         //  параметры шрифта
              "name": "$FieldFont",           //     название
              "size": 15,                     //  размер
              "align": "center",              //     выравнивание текста (left, center, right)
              "bold": false,                  //  обычный (false) или жирный (true)
              "italic": false                 //  обычный (false) или курсив (true)
            },
            "shadow": {                       //  параметры тени
              "alpha": 100,                   //  прозрачность
              "color": null,                  //  цвет
              "angle": 45,                    //  угол смещения
              "strength": 300,                //  интенсивность
              "distance": 0,                  //  дистанция смещение
              "size": 6                       //  размер
            },
            "speed": 2,                       //  время отображения отлетающего урона
            "maxRange": 60,                   //  расстояние, на которое отлетает урон
            "damageMessage": "{{dmg}}"	      //  текст при уроне (см. описание макросов в readme-ru.txt)
          },
          "damageTextPlayer": {
            "$ref": {  "path": "def.damageText" }
          },
          "damageTextSquadman": {
            "$ref": {  "path": "def.damageText" }
          },
          // Блок текстовых полей
  "textFields": 
            ${ "def.textFields" }
        },
  "enemy": {
            "$ref": { "path": "ally" }
        }
}