﻿/**
 * Parameters of the Players Panels ("ears").
 * Параметры панелей игроков ("ушей").
 */
{
"def": {
    // Text fields shadow definition.
    // Шаблон тени текстовых полей.
	"textFieldShadow": { "color": "0x000000", "alpha": 0.75, "blur": 2, "strength": 1, "distance": 0, "angle": 0 },

    // Squad icon definition.
    // Шаблон иконки взвода.
	"squad": { "alpha": "{{alive?100|50}}", "src": "xvm://configs/demon2597/img/{{squad?own_}}{{squad-num?squad}}.png" },
	"squadNumLeft": { "x": 12, "align": "center", "alpha": "{{alive?100|50}}",
			"format": "<font face='$FieldFont' size='13' color='#FFFFFF'>{{squad-num}}</font>",
			"shadow": ${ "def.textFieldShadow" }
		},
	"squadNumRight": { "x": 13, "align": "center", "alpha": "{{alive?100|50}}",
			"format": "<font face='$FieldFont' size='13' color='#FFFFFF'>{{squad-num}}</font>",
			"shadow": ${ "def.textFieldShadow" }
		},
    // Enemy spotted status marker definition.
    // Шаблон маркера статуса засвета противника.
        "SpottedMarker": { "x": -6, "y": 2, "w": 5, "h": 22, "bgColor": "{{c:spotted}}", "borderColor": "0x000000", "alpha": "{{a:spotted}}", "bindToIcon": true },

    // "none" panels text fields definition.
    // Шаблон текстовых полей "none" ушей.
	"noneBgAliveLeft": { "w": "{{xvm-stat?210|190}}", "alpha": "{{alive?40|0}}", "src": "xvm://configs/demon2597/img/noneBgAliveLeft.png" },
	"noneBgAliveRight": { "w": "{{xvm-stat?210|190}}", "alpha": "{{alive?40|0}}", "src": "xvm://configs/demon2597/img/noneBgAliveRight.png" },
	"noneBgDeadLeft": { "w": "{{xvm-stat?210|190}}", "alpha": "{{alive?0|40}}", "src": "xvm://configs/demon2597/img/noneBgDeadLeft.png" },
	"noneBgDeadRight": { "w": "{{xvm-stat?210|190}}", "alpha": "{{alive?0|40}}", "src": "xvm://configs/demon2597/img/noneBgDeadRight.png" },
	"noneSelected": { "w": "{{xvm-stat?210|190}}", "src": "xvm://configs/demon2597/img/{{selected}}.png" },
	"noneHpScaleBgDimmerLeft": { "x": 26, "y": 20, "w": 100, "h": "{{hp?3|0}}", "bgColor": "0x000000", "alpha": "{{alive?20|0}}" },
	"noneHpScaleBgDimmerRight": { "x": 26, "y": 20, "w": 100, "h": "{{hp?3|0}}", "bgColor": "0x000000", "alpha": "{{alive?10|0}}" },
	"noneHpScaleBgAlive": { "x": 25, "y": 19, "w": "{{player?0|102}}", "h": "{{hp?5|0}}", "bgColor": "{{c:system}}", "alpha": "{{alive?30|0}}", "borderColor": "0x000000" },
	"noneHpScaleBgDead": { "x": 25, "y": 19, "w": "{{player?0|102}}", "h": 5, "bgColor": "{{c:system}}", "alpha": "{{alive?0|30}}", "borderColor": "0x000000" },
	"noneHpScale": { "x": 26, "y": 20, "w": "{{hp-ratio:100}}", "h": "{{hp?3|0}}", "bgColor": "{{c:system}}", "alpha": "{{player?0|70}}" },
	"noneHpScaleBgAlivePlayer": { "x": 25, "y": 19, "w": "{{player?102|0}}", "h": "{{hp?5|0}}", "bgColor": "0xFFCC66", "alpha": "{{alive?30|0}}", "borderColor": "0x000000" },
	"noneHpScaleBgDeadPlayer": { "x": 25, "y": 19, "w": "{{player?102|0}}", "h": 5, "bgColor": "0xBF891D", "alpha": "{{alive?0|30}}", "borderColor": "0x000000" },
	"noneHpScalePlayer": { "x": 26, "y": 20, "w": "{{hp-ratio:100}}", "h": "{{hp?3|0}}", "bgColor": "0xFFCC66", "alpha": "{{player?70|0}}" },
	"noneHpKnown": { "x": 76, "y": 2, "align": "center", "alpha": "{{hp?100|0}}",
			"format": "<font face='$FieldFont' size='{{alive?13|0}}' color='{{c:hp-ratio}}' alpha='{{ready?#FF|#80}}'><font face='ZurichCondMono'>{{hp%4d}}</font> <font face='ZurichCondMono'>({{hp-ratio%3d}}</font>% / <font face='ZurichCondMono'>{{hp-max%4d}})</font></font>",
			"shadow": ${ "def.textFieldShadow" } 
		},
	"noneHpUnknown": { "x": 76, "y": -14, "valign": "center", "align": "center", "alpha": "{{hp?0|100}}",
			"format": "<font face='XVMSymbol' size='{{alive?24|0}}' color='#9284C3' alpha='{{ready?#FF|#80}}'>{{l10n:No data}}</font>",
			"shadow": ${ "def.textFieldShadow" } 
		},
	"noneHpDead": { "x": 76, "y": -1, "align": "center",
			"format": "<font face='XVMSymbol' size='{{alive?0|24}}' color='#FFFFFF' alpha='#80'>&#x2B;</font>",
			"shadow": ${ "def.textFieldShadow" } 
		},
	"noneFrags": { "x": 139, "align": "center", "valign": "center",
			"format": "<font face='ZurichCondMono' size='13' color='#FFFFFF' alpha='{{alive?#FF|#80}}'>{{frags}}</font>",
			"shadow": ${ "def.textFieldShadow" }
		},
	"noneRatingLeft": { "x": 148, "y": 1, "alpha": "{{xvm-stat?100|0}}",
			"format": ${ "_rating.xc": "playersPanel.formatNoneRatingLeft" },
			"shadow": ${ "def.textFieldShadow" }
		},
	"noneRatingRight": { "x": 148, "y": 1, "alpha": "{{xvm-stat?100|0}}",
			"format": ${ "_rating.xc": "playersPanel.formatNoneRatingRight" },
			"shadow": ${ "def.textFieldShadow" }
		},
	"noneIconLeft": { "x": "{{xvm-stat?171|151}}", "y": "{{tk?-999|1}}", "alpha": "{{alive?100|50}}", "src": "xvm://res/contourAlly/{{vehiclename}}.png" },
	"noneTkIconLeft": { "x": "{{xvm-stat?171|151}}", "y": "{{tk?1|-999}}", "src": "xvm://res/contourAlly/{{vehiclename}}.png", "highlight": true },
	"noneIconRight": { "x": "{{xvm-stat?171|151}}", "y": 1, "alpha": "{{alive?100|50}}", "src": "xvm://res/contourEnemy/{{vehiclename}}.png" },
        "noneSpottedMarker": { "x": "{{xvm-stat?250|230}}", "y": 2, "w": 5, "h": 22, "bgColor": "{{c:spotted}}", "borderColor": "0x000000", "alpha": "{{a:spotted}}" },

    // "short" panels text fields definition.
    // Шаблон текстовых полей "short" ушей.
	"shortHpLeft": { "w": 18, "$ref": { "path": "def.mediumHpLeft" } },
	"shortHpRight": { "w": 18, "$ref": { "path": "def.mediumHpRight" } },

    // "medium" panels text fields definition.
    // Шаблон текстовых полей "medium" ушей.
	"mediumHpLeft": { "x": 23, "y": 1, "alpha": "{{alive?40|0}}", "src": "xvm://configs/demon2597/img/{{c:hp-ratio}}_left.png" },
	"mediumHpRight": { "x": 23, "y": 1, "alpha": "{{alive?40|0}}", "src": "xvm://configs/demon2597/img/{{c:hp-ratio}}_right.png" },
	"mediumNameLeft": { "x": 23, "y": 2,
			"format": "<font face='$FieldFont' color='#FFFFFF' alpha='{{ready?#FF|#80}}'><font size='{{alive?13|0}}'><font color='{{squad?#FF914C}}'><font color='{{player?#FFCC66}}'><font color='{{tk?#00EAFF}}'>{{name%.13s~..}} </font></font></font></font><font size='{{alive?12|0}}' color='#FFCC66'>{{clannb}}</font></font><font face='$FieldFont' color='#FFFFFF' alpha='#80'><font size='{{alive?0|13}}'><font color='{{squad?#FF914C}}'><font color='{{player?#FFCC66}}'><font color='{{tk?#00EAFF}}'>{{name%.13s~..}} </font></font></font></font><font size='{{alive?0|12}}' color='#FFCC66'>{{clannb}}</font></font>",
			"shadow": ${ "def.textFieldShadow" }
		},
	"mediumNameRight": { "x": 23, "y": 2,
			"format": "<font face='$FieldFont' color='#FFFFFF' alpha='{{ready?#FF|#80}}'><font size='{{alive?12|0}}' color='#FFCC66'>{{clannb}}</font><font size='{{alive?13|0}}'> {{name%.13s~..}}</font></font><font face='$FieldFont' color='#FFFFFF' alpha='#80'><font size='{{alive?0|12}}' color='#FFCC66'>{{clannb}}</font><font size='{{alive?0|13}}'> {{name%.13s~..}}</font></font>",
			"shadow": ${ "def.textFieldShadow" }
		},
	"mediumRatingLeft": { "x": 170, "$ref": { "path": "def.noneRatingLeft" } },
	"mediumRatingRight": { "x": 169, "$ref": { "path": "def.noneRatingRight" } },
	"mediumFrags": { "x": 161, "$ref": { "path": "def.noneFrags" } },

    // "medium2" panels text fields definition.
    // Шаблон текстовых полей "medium2" ушей.
	"medium2HpLeft": { "w": "{{xvm-stat?35|18}}", "$ref": { "path": "def.mediumHpLeft" } },
	"medium2HpRight": { "w": "{{xvm-stat?35|18}}", "$ref": { "path": "def.mediumHpRight" } },
	"medium2Frags": { "x": 30, "$ref": { "path": "def.noneFrags" } },
	"medium2Rating": { "x": 40, "valign": "center", "alpha": "{{xvm-stat?100|0}}",
			"format": ${ "_rating.xc": "playersPanel.formatMedium2Rating" },
			"shadow": ${ "def.textFieldShadow" }
		},

    // "large" panels text fields definition.
    // Шаблон текстовых полей "large" ушей.
	"largeHpLeft": { "x": "{{xvm-stat?45|23}}", "$ref": { "path": "def.mediumHpLeft" } },
	"largeHpRight": { "x": "{{xvm-stat?45|23}}", "$ref": { "path": "def.mediumHpRight" } },
	"largeKb": { "x": 23, "valign": "center", "alpha": "{{xvm-stat?100|0}}",
			"format": "<font face='ZurichCondMono' size='13' color='{{c:kb|#FFFFFF}}' alpha='{{alive?#FF|#80}}'>{{kb%2d~k|--k}}</font>",
			"shadow": ${ "def.textFieldShadow" }
		},
	"largeNameLeft": { "x": "{{xvm-stat?45|23}}", "$ref": { "path": "def.mediumNameLeft" } },
	"largeNameRight": { "x": "{{xvm-stat?45|23}}", "$ref": { "path": "def.mediumNameRight" } },
	"largeFrags": { "x": "{{xvm-stat?184|162}}", "$ref": { "path": "def.noneFrags" } },
	"largeRating": { "x": 194, "$ref": { "path": "def.medium2Rating" } }
  },
  "playersPanel": {
    // Opacity percentage of the panels. 0 - transparent, 100 - opaque.
    // Прозрачность в процентах ушей. 0 - прозрачные, 100 - не прозрачные.
    "alpha": 40,
    // Opacity percentage of icons in the panels. 0 - transparent ... 100 - opaque.
    // Прозрачность в процентах иконок в ушах. 0 - прозрачные, 100 - не прозрачные.
    "iconAlpha": 100,
    // true - Disable Platoon icons.
    // true - убрать отображение иконки взвода.
    "removeSquadIcon": true,
    // true - disable background of the selected player.
    // true - убрать подложку выбранного игрока.
    "removeSelectedBackground": false,
    // true - Remove the Players Panel mode switcher (buttons for changing size).
    // true - убрать переключатель режимов ушей мышкой.
    "removePanelsModeSwitcher": false,
    // Start panels mode. Possible values: "none", "short", "medium", "medium2", "large".
    // Начальный режим ушей. Возможные значения: "none", "short", "medium", "medium2", "large".
    "startMode": "large",
    // Alternative panels mode. Possible values: null, "none", "short", "medium", "medium2", "large".
    // Альтернативный режим ушей. Возможные значения: null, "none", "short", "medium", "medium2", "large".
    "altMode": "none",
    // Display options for Team/Clan logos.
    // Параметры отображения иконки игрока/клана.
    "clanIcon": {
      // false - Disable Team/Clan logos.
      // false - не отображать иконки игрока/клана.
      "show": false,
      // Position on the X axis, relative to the vehicle icon.
      // Положение по оси X относительно иконки танка.
      "x": 0,
      // Position on the Y axis, relative to the vehicle icon.
      // Положение по оси Y относительно иконки танка.
      "y": 6,
      // Position on the X axis for right side (positive values run to the *inside* of the table).
      // Положение по оси X для правых ушей (положительные значения поместят иконку *внутрь* панели).
      "xr": 0,
      // Position on the Y axis for right side.
      // Положение по оси Y для правых ушей.
      "yr": 6,
      // Width of the Team/Clan logo.
      // Ширина иконки игрока/клана.
      "w": 16,
      // Height of the Team/Clan logo.
      // Высота иконки игрока/клана.
      "h": 16,
      // Transparency of the Team/Clan logo.
      // Прозрачность иконки игрока/клана.
      "alpha": 90
    },
    // Options for the "none" panels - empty panels.
    // Режим ушей "none" - пустые уши.
    "none": {
      // false - disable (отключить)
      "enabled": true,
      // Layout ("vertical" or "horizontal")
      // Размещение ("vertical" - вертикально, или "horizontal" - горизонтально)
      "layout": "vertical", 
      // Extra fields.
      // Дополнительные поля.
      "extraFields": {
        "leftPanel": {
          "x": 0, // from left side of screen
          "y": 65,
          "width": 350,
          "height": 25,
          // Set of formats for left panel
          // Набор форматов для левой панели
          // example:
          // "format": [
          //   // simple format (just a text)
          //   "{{nick}}",
          //   "<img src='xvm://res/img/panel-bg-l-{{alive|dead}}.png' width='318' height='28'>",
          //   // extended format
          //   { "x": 20, "y": 10, "borderColor": "0xFFFFFF", "format": "{{nick}}" },
          //   { "x": 200, "src": "xvm://res/contour/{{vehiclename}}.png" }
          //   Из клиента в AS2 (бой):
          //   { "x": 200, "src": "img://../gui/maps/icons/vehicle/{{vehiclename}}.png" }
          //   Из клиента в AS3 (ангар):
          //   { "x": 200, "src": "img://gui/maps/icons/vehicle/{{vehiclename}}.png" }
          // ]
          //
          // types of formats available for extended format:
          //   - MovieClip (for loading image)
          //   - TextField (for writing text and creating rectangles)
          // if "src" field is present, MovieClip format will be used
          // if "src" field is absent, TextField format will be used
          //
          // fields available for extended format:
          //   "src" - resource path ("xvm://res/contour/{{vehiclename}}.png")
          //   "format" - text format (macros allowed)
          //
          // fields available for both MovieClip and TextField formats:
          //   "x" - x position (macros allowed)
          //   "y" - y position (macros allowed)
          //   "w" - width (macros allowed)
          //   "h" - height (macros allowed)
          //   "bindToIcon" - if enabled, x position is binded to vehicle icon (default false)
          //   "alpha" - transparency in percents (0..100) (macros allowed)
          //   "rotation" - rotation in degrees (0..360) (macros allowed)
          //   "align" - horizontal alignment ("left", "center", "right")
          //      for left panel default value is "left"
          //      for right panel default value is "right"
          //   "scaleX", "scaleY" - scaling (use negative values for mirroring)
          //   Зеркалирование надо: scaleX = -1
          //
          // fields available for TextField format only:
          //   "valign" - vertical alignment ("top", "center", "bottom")
          //      default value is "top"
          //   "borderColor" - if set, draw border with specified color (macros allowed)
          //   "bgColor" - if set, draw background with specified color (macros allowed)
          //   "antiAliasType" - anti aliasing mode ("advanced" or "normal")
          //   "shadow": {
          //     "distance" (in pixels)
          //     "angle"    (0.0 .. 360.0)
          //     "color"    "0xXXXXXX"
          //     "alpha"    (0.0 .. 1.0)
          //     "blur"     (0.0 .. 255.0)
          //     "strength" (0.0 .. 255.0)
          //    }
          //
          // fields available for MovieClip format only:
          //     "highlight" - highlight icon depending on the player state, default false
          //
          // * all fields are optional
          //
          "formats": [
		${ "def.noneBgAliveLeft" },
		${ "def.noneBgDeadLeft" },
		${ "def.noneSelected" },
		${ "def.squad" },
		${ "def.squadNumLeft" },
		${ "def.noneHpScaleBgDimmerLeft" },
		${ "def.noneHpScaleBgAlive" },
		${ "def.noneHpScaleBgDead" },
		${ "def.noneHpScale" },
        	${ "def.noneHpScaleBgAlivePlayer" },
		${ "def.noneHpScaleBgDeadPlayer" },
		${ "def.noneHpScalePlayer" },
		${ "def.noneHpKnown" },
		${ "def.noneHpUnknown" },
		${ "def.noneHpDead" },
		${ "def.noneFrags" },
		${ "def.noneRatingLeft" },
		${ "def.noneIconLeft" },
		${ "def.noneTkIconLeft" }
	  ]
        },
        "rightPanel": {
          "x": 0, // from right side of screen
          "y": 65,
          "width": 350,
          "height": 25,
          // Set of formats for right panel (extended format supported, see above)
          // Набор форматов для правой панели (поддерживается расширенный формат, см. выше)
          "formats": [
		${ "def.noneBgAliveRight" },
		${ "def.noneBgDeadRight" },
		${ "def.squad" },
		${ "def.squadNumRight" },
		${ "def.noneHpScaleBgDimmerRight" },
		${ "def.noneHpScaleBgAlive" },
		${ "def.noneHpScaleBgDead" },
		${ "def.noneHpScale" },
		${ "def.noneHpKnown" },
		${ "def.noneHpUnknown" },
		${ "def.noneHpDead" },
		${ "def.noneFrags" },
		${ "def.noneRatingRight" },
		${ "def.noneIconRight" },
		${ "def.noneSpottedMarker" }
	  ]
        }
      }
    },
    // Options for the "short" panels - panels with frags and vehicle icon.
    // Режим ушей "short" - короткие уши (фраги и иконка танка).
    "short": {
      // false - disable (отключить)
      "enabled": true,
      // Width of the column, 0-250. Default is 0.
      // Ширина поля, 0-250. По умолчанию: 0.
      "width": 16,
      // Display format for frags (macros allowed, see readme-en.txt).
      // Формат отображения фрагов (допускаются макроподстановки, см. readme-ru.txt).
      "fragsFormatLeft": "",
      "fragsFormatRight": "",
      // Extra fields. Each field have size 350x25. Fields are placed one above the other.
      // Дополнительные поля. Каждое поле имеет размер 350x25. Поля располагаются друг над другом.
      // Set of formats for left panel (extended format supported, see above)
      // Набор форматов для левой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsLeft": [
		${ "def.shortHpLeft" },
		${ "def.squad" },
		${ "def.squadNumLeft" },
		${ "def.medium2Frags" }
	],
      // Set of formats for right panel (extended format supported, see above)
      // Набор форматов для правой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsRight": [
		${ "def.shortHpRight" },
		${ "def.squad" },
		${ "def.squadNumRight" },
		${ "def.medium2Frags" },
		${ "def.SpottedMarker" }
	]
    },
    // Options for the "medium" panels - the first of the medium panels.
    // Режим ушей "medium" - первые средние уши в игре.
    "medium": {
      // false - disable (отключить)
      "enabled": true,
      // Minimum width of the player's name column, 0-250. Default is 46.
      // Минимальная ширина поля имени игрока, 0-250. По умолчанию: 46.
      "width": "{{xvm-stat?171|151}}",
      // Display format for the left panel (macros allowed, see readme-en.txt).
      // Формат отображения для левой панели (допускаются макроподстановки, см. readme-ru.txt).
      "formatLeft": "",
      // Display format for the right panel (macros allowed, see readme-en.txt).
      // Формат отображения для правой панели (допускаются макроподстановки, см. readme-ru.txt).
      "formatRight": "",
      // Display format for frags (macros allowed, see readme-en.txt).
      // Формат отображения фрагов (допускаются макроподстановки, см. readme-ru.txt).
      "fragsFormatLeft": "",
      "fragsFormatRight": "",
      // Extra fields. Each field have size 350x25. Fields are placed one above the other.
      // Дополнительные поля. Каждое поле имеет размер 350x25. Поля располагаются друг над другом.
      // Set of formats for left panel (extended format supported, see above)
      // Набор форматов для левой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsLeft": [
		${ "def.mediumHpLeft" },
		${ "def.squad" },
		${ "def.squadNumLeft" },
		${ "def.mediumNameLeft" },
		${ "def.mediumFrags" },
		${ "def.mediumRatingLeft" }
	],
      // Set of formats for right panel (extended format supported, see above)
      // Набор форматов для правой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsRight": [
		${ "def.mediumHpRight" },
		${ "def.squad" },
		${ "def.squadNumRight" },
		${ "def.mediumNameRight" },
		${ "def.mediumFrags" },
		${ "def.mediumRatingRight" },
		${ "def.SpottedMarker" }
	]
    },
    // Options for the "medium2" panels - the second of the medium panels.
    // Режим ушей "medium2" - вторые средние уши в игре.
    "medium2": {
      // false - disable (отключить)
      "enabled": true,
      // Maximum width of the vehicle name column, 0-250. Default is 65.
      // Максимальная ширина поля названия танка, 0-250. По умолчанию: 65.
      "width": ${ "_rating.xc": "playersPanel.medium2Width" },
      // Display format for the left panel (macros allowed, see readme-en.txt).
      // Формат отображения для левой панели (допускаются макроподстановки, см. readme-ru.txt).
      "formatLeft": "",
      // Display format for the right panel (macros allowed, see readme-en.txt).
      // Формат отображения для правой панели (допускаются макроподстановки, см. readme-ru.txt).
      "formatRight": "",
      // Display format for frags (macros allowed, see readme-en.txt).
      // Формат отображения фрагов (допускаются макроподстановки, см. readme-ru.txt).
      "fragsFormatLeft": "",
      "fragsFormatRight": "",
      // Extra fields. Each field have size 350x25. Fields are placed one above the other.
      // Дополнительные поля. Каждое поле имеет размер 350x25. Поля располагаются друг над другом.
      // Set of formats for left panel (extended format supported, see above)
      // Набор форматов для левой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsLeft": [
		${ "def.medium2HpLeft" },
		${ "def.squad" },
		${ "def.squadNumLeft" },
		${ "def.medium2Frags" },
		${ "def.medium2Rating" }
	],
      // Set of formats for right panel (extended format supported, see above)
      // Набор форматов для правой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsRight": [
		${ "def.medium2HpRight" },
		${ "def.squad" },
		${ "def.squadNumRight" },
		${ "def.medium2Frags" },
		${ "def.medium2Rating" },
		${ "def.SpottedMarker" }
	]
    },
    // Options for the "large" panels - the widest panels.
    // Режим ушей "large" - широкие уши в игре.
    "large": {
      // false - disable (отключить)
      "enabled": true,
      // Minimum width of the player's name column, 0-250. Default is 170.
      // Минимальная ширина поля имени игрока, 0-250. По умолчанию: 170.
      "width": ${ "_rating.xc": "playersPanel.largeWidth" },
      // Display format for player nickname (macros allowed, see readme-en.txt).
      // Формат отображения имени игрока (допускаются макроподстановки, см. readme-ru.txt).
      "nickFormatLeft": "",
      "nickFormatRight": "",
      // Display format for vehicle name (macros allowed, see readme-en.txt).
      // Формат отображения названия танка (допускаются макроподстановки, см. readme-ru.txt).
      "vehicleFormatLeft": "",
      "vehicleFormatRight": "",
      // Display format for frags (macros allowed, see readme-en.txt).
      // Формат отображения фрагов (допускаются макроподстановки, см. readme-ru.txt).
      "fragsFormatLeft": "",
      "fragsFormatRight": "",
      // Extra fields. Each field have size 350x25. Fields are placed one above the other.
      // Дополнительные поля. Каждое поле имеет размер 350x25. Поля располагаются друг над другом.
      // Set of formats for left panel (extended format supported, see above)
      // Набор форматов для левой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsLeft": [
		${ "def.largeHpLeft" },
		${ "def.squad" },
		${ "def.squadNumLeft" },
		${ "def.largeKb" },
		${ "def.largeNameLeft" },
		${ "def.largeFrags" },
		${ "def.largeRating" }
	],
      // Set of formats for right panel (extended format supported, see above)
      // Набор форматов для правой панели (поддерживается расширенный формат, см. выше)
      "extraFieldsRight": [
		${ "def.largeHpRight" },
		${ "def.squad" },
		${ "def.squadNumRight" },
		${ "def.largeKb" },
		${ "def.largeNameRight" },
		${ "def.largeFrags" },
		${ "def.largeRating" },
		${ "def.SpottedMarker" }
	]
    }
  }
}
