﻿/**
 * Color settings.
 * Настройки цветов.
 */
{
  "def": {
     // System and damage color definition.
     // Шаблон системного цвета и цвета для урона.
    "al": "0x60FF00",  // ally       / союзник
    "sq": "0xFF914C",  // squadman   / взводный
    "tk": "0x00EAFF",  // teamKiller / тимкиллер
    "en": "0xFE0E00",  // enemy      / противник
    "pl": "0xFFCC66",  // player     / игрок
     // Dynamic color definition.
     // Шаблон динамического цвета.
    "color0": "0xDBDBDB",  // neutral       / нейтрально
    "color1": "0xFE0E00",  // bad           / плохо
    "color2": "0xFE7903",  // below average / ниже среднего
    "color3": "0xF8F400",  // normal        / средне
    "color4": "0x60FF00",  // good          / хорошо
    "color5": "0x02C9B3",  // very good     / очень хорошо
    "color6": "0xD042F3",  // skillful      / мастерски
     // HP dynamic color definition.
     // Шаблон динамического цвета для здоровья.
    "hpColor1":	"0xFC857E",  // low           / низкий
    "hpColor2":	"0xFFC266",  // below average / ниже среднего
    "hpColor3":	"0xFFFFFF",  // average       / средний
    "hpColor4":	"0xFFFFFF"   // above-average / выше среднего
  },
  "colors": {
    // System colors.
    // Системные цвета.
    "system": {
      // Format: object_state
      // Object: ally, squadman, teamKiller, enemy
      // State:  alive, dead, blowedup
      // ----
      // Формат: объект_состояние
      // Объект: ally - союзник, squadman - взводный, teamKiller - тимкиллер, enemy - противник
      // Состояние: alive - живой, dead - мертвый, blowedup - взорвана боеукладка
      //Союзник
      "ally_alive":          ${ "def.al" }, // живой
      "ally_dead":           "0x008A00",    // мертвый
      "ally_blowedup":       "0x008A00",    // взорван БК
      //Взводный
      "squadman_alive":      ${ "def.sq" }, // живой
      "squadman_dead":       "0xCA7000",    // мертвый
      "squadman_blowedup":   "0xCA7000",    // взорван БК
      //Тимкиллер
      "teamKiller_alive":    ${ "def.tk" }, // живой
      "teamKiller_dead":     "0x097783",    // мертвый
      "teamKiller_blowedup": "0x097783",    // взорван БК
      //Противник
      "enemy_alive":         ${ "def.en" }, // живой
      "enemy_dead":          "0xB30B02",    // мертвый
      "enemy_blowedup":      "0xB30B02",    // взорван БК
      "ally_base":           ${ "def.al" }, // база союзников
      "enemy_base":          ${ "def.en" }  // база противников
    },
    // Dynamic color by damage kind.
    // Динамический цвет по типу урона.
    "dmg_kind": {
      "shot":            "0xFFAA55",  // попадание
      "fire":            "0xFF5745",  // пожар
      "ramming":         "0x577A3D",  // таран
      "world_collision": "0x805A37",  // столкновение с объектами, падение
      "death_zone":      "0xCCCCCC",  // выход из игровой зоны
      "drowning":        "0x265CFF",  // затопление
      "other":           "0xCCCCCC"   // другое
    },
    // Dynamic color by vehicle type.
    // Динамический цвет по типу техники.
    "vtype": {
      // Цвет для легких танков.
      "LT": "0xA2FF9A",
      // Цвет для средних танков.
      "MT": "0xFFF198",
      // Цвет для тяжелых танков.
      "HT": "0xCCCCCC",
      // Цвет для арты.
      "SPG": "0xFFACAC",
      // Цвет для ПТ.
      "TD": "0xA0CFFF",
      // Цвет для премиумной техники.
      "premium": "0xFFCC66",
      // Включить/выключить использование премиумного цвета.
      "usePremiumColor": false
    },
    // Dynamic color by spotted status
    // Динамический цвет по статусу засвета
    "spotted": {
      "neverSeen":      "0x800600",
      "lost":           "0xD9D9D9",
      "revealed":       "0xFE0E00",
      "dead":           "0x595959",
      "neverSeen_arty": "0x800600",
      "lost_arty":      "0xD9D9D9",
      "revealed_arty":  "0xFE0E00",
      "dead_arty":      "0x595959"
    },
    // Color settings for damage.
    // Настройки цвета для урона.
  "damage": {
      // Format: src_dst_type.
      // Src:  ally, squadman, enemy, unknown, player.
      // Dst:  ally, squadman, allytk, enemytk, enemy.
      // Type: hit, kill, blowup.
      // ----
      // Формат: источник_получатель_тип.
      // Источник:   ally - союзник, squadman - взводный, enemy - противник, unknown - неизвестный (не виден игроку), player - игрок.
      // Получатель: ally, squadman, enemy, allytk - союзник тимкиллер, enemytk - противник тимкиллер.
      // Тип:        hit - попадание, kill - убийство, blowup - боеукладка.
      "ally_ally_hit":		  "0x00CCFF",     // "teamKiller"
      "ally_ally_kill":		  ${ "def.tk" },  // "teamKiller"
      "ally_ally_blowup":	  ${ "def.tk" },  // "teamKiller"
      "ally_squadman_hit":	  "0x00CCFF",	  // "teamKiller"
      "ally_squadman_kill":	  ${ "def.tk" },  // "teamKiller"
      "ally_squadman_blowup":	  ${ "def.tk" },  // "teamKiller"
      "ally_enemy_hit":		  ${ "def.en" },  // "enemy"
      "ally_enemy_kill":	  ${ "def.en" },  // "enemy"
      "ally_enemy_blowup":	  ${ "def.en" },  // "enemy"
      "ally_allytk_hit":	  "0x00CCFF",	  // "teamKiller"
      "ally_allytk_kill":	  ${ "def.tk" },  // "teamKiller"
      "ally_allytk_blowup":	  ${ "def.tk" },  // "teamKiller"
      "ally_enemytk_hit":	  ${ "def.en" },  // "enemy"
      "ally_enemytk_kill":	  ${ "def.en" },  // "enemy"
      "ally_enemytk_blowup":	  ${ "def.en" },  // "enemy"
      "squadman_ally_hit":	  ${ "def.tk" },  // "teamKiller"
      "squadman_ally_kill":	  ${ "def.tk" },  // "teamKiller"
      "squadman_ally_blowup":	  ${ "def.tk" },  // "teamKiller"
      "squadman_squadman_hit":	  ${ "def.tk" },  // "teamKiller"
      "squadman_squadman_kill":	  ${ "def.tk" },  // "teamKiller"
      "squadman_squadman_blowup": ${ "def.tk" },  // "teamKiller"
      "squadman_enemy_hit":	  ${ "def.sq" },  // "enemy"
      "squadman_enemy_kill":	  ${ "def.sq" },  // "enemy"
      "squadman_enemy_blowup":	  ${ "def.sq" },  // "enemy"
      "squadman_allytk_hit":	  ${ "def.tk" },  // "teamKiller"
      "squadman_allytk_kill":	  ${ "def.tk" },  // "teamKiller"
      "squadman_allytk_blowup":	  ${ "def.tk" },  // "teamKiller"
      "squadman_enemytk_hit":	  ${ "def.sq" },  // "enemy"
      "squadman_enemytk_kill":	  ${ "def.sq" },  // "enemy"
      "squadman_enemytk_blowup":  ${ "def.sq" },  // "enemy"
      "enemy_ally_hit":		  "0x36AD00", 	  // "ally"
      "enemy_ally_kill":	  ${ "def.al" },  // "ally"
      "enemy_ally_blowup":	  ${ "def.al" },  // "ally"
      "enemy_squadman_hit":	  "0xFF7D2E",	  // "squadman"
      "enemy_squadman_kill":	  ${ "def.sq" },  // "squadman"
      "enemy_squadman_blowup":	  ${ "def.sq" },  // "squadman"
      "enemy_enemy_hit":	  ${ "def.en" },  // "enemy"
      "enemy_enemy_kill":	  ${ "def.en" },  // "enemy"
      "enemy_enemy_blowup":	  ${ "def.en" },  // "enemy"
      "enemy_allytk_hit":	  "0x36AD00",     // "ally"
      "enemy_allytk_kill":	  ${ "def.al" },  // "ally"
      "enemy_allytk_blowup":	  ${ "def.al" },  // "ally"
      "enemy_enemytk_hit":	  ${ "def.en" },  // "enemy"
      "enemy_enemytk_kill":	  ${ "def.en" },  // "enemy"
      "enemy_enemytk_blowup":	  ${ "def.en" },  // "enemy"
      "unknown_ally_hit":	  "0x36AD00",     // "ally"
      "unknown_ally_kill":	  ${ "def.al" },  // "ally"
      "unknown_ally_blowup":	  ${ "def.al" },  // "ally"
      "unknown_squadman_hit":	  "0xFF7D2E",     // "squadman"
      "unknown_squadman_kill":	  ${ "def.sq" },  // "squadman"
      "unknown_squadman_blowup":  ${ "def.sq" },  // "squadman"
      "unknown_enemy_hit":	  ${ "def.en" },  // "enemy"
      "unknown_enemy_kill":	  ${ "def.en" },  // "enemy"
      "unknown_enemy_blowup":	  ${ "def.en" },  // "enemy"
      "unknown_allytk_hit":	  "0x36AD00",     // "ally"
      "unknown_allytk_kill":	  ${ "def.al" },  // "ally"
      "unknown_allytk_blowup":	  ${ "def.al" },  // "ally"
      "unknown_enemytk_hit":	  ${ "def.en" },  // "enemy"
      "unknown_enemytk_kill":	  ${ "def.en" },  // "enemy"
      "unknown_enemytk_blowup":	  ${ "def.en" },  // "enemy"
      "player_ally_hit":	  ${ "def.pl" },  // "me"
      "player_ally_kill":	  ${ "def.pl" },  // "me"
      "player_ally_blowup":	  ${ "def.pl" },  // "me"
      "player_squadman_hit":	  ${ "def.pl" },  // "me"
      "player_squadman_kill":	  ${ "def.pl" },  // "me" 
      "player_squadman_blowup":	  ${ "def.pl" },  // "me"
      "player_enemy_hit":	  ${ "def.pl" },  // "me"
      "player_enemy_kill":	  ${ "def.pl" },  // "me"
      "player_enemy_blowup":	  ${ "def.pl" },  // "me"
      "player_allytk_hit":	  ${ "def.pl" },  // "me"
      "player_allytk_kill":	  ${ "def.pl" },  // "me"
      "player_allytk_blowup":	  ${ "def.pl" },  // "me"
      "player_enemytk_hit":	  ${ "def.pl" },  // "me"
      "player_enemytk_kill":	  ${ "def.pl" },  // "me"
      "player_enemytk_blowup":	  ${ "def.pl" }   // "me"
    },
    // Values ​​below should be from smaller to larger.
    // Значения ниже должны быть от меньшего к большему.
    // ----
    // Dynamic color by remaining absolute health.
    // Динамический цвет по оставшемуся здоровью.
    "hp": [
      { "value": 201,	"color": ${ "def.hpColor1" } },	// Цвет для значений менее 201
      { "value": 401,	"color": ${ "def.hpColor2" } },	// Цвет для значений менее 401
      { "value": 1001,	"color": ${ "def.hpColor3" } },	// Цвет для значений менее 1001
      { "value": 9999,	"color": ${ "def.hpColor4" } }	// Цвет для остальных значений
    ],
    // Dynamic color by remaining health percent.
    // Динамический цвет по проценту оставшегося здоровья.
    "hp_ratio": [
      { "value": 24.5,	"color": ${ "def.hpColor1" } },	// Цвет для значений менее 25 проц
      { "value": 49.5,	"color": ${ "def.hpColor2" } },	// Цвет для значений менее 50 проц
      { "value": 74.5,	"color": ${ "def.hpColor3" } },	// Цвет для значений менее 75 проц
      { "value": 101,	"color": ${ "def.hpColor4" } }	// Цвет для остальных значений
    ],
    // Dynamic color for XVM Scale.
    // Динамический цвет по шкале XVM.
    // http://www.koreanrandom.com/forum/topic/2625-/
    "x": [
      { "value": 16.5,	"color": ${ "def.color1" } },   //    0 - 16.5 - bad		(20% of players)
      { "value": 33.5,	"color": ${ "def.color2" } },   // 16.5 - 33.5 - below average	(better then 20% of players)
      { "value": 52.5,	"color": ${ "def.color3" } },   // 33.5 - 52.5 - normal		(better then 60% of players)
      { "value": 75.5,	"color": ${ "def.color4" } },   // 52.5 - 75.5 - good		(better then 90% of players)
      { "value": 92.5,	"color": ${ "def.color5" } },   // 75.5 - 92.5 - very good	(better then 99% of players)
      { "value": 999,	"color": ${ "def.color6" } }    // 92.5 - XX   - skillful     	(better then 99.9% of players)
    ],
    // Dynamic color by efficiency.
    // Динамический цвет по эффективности.
    "eff": [
      { "value": 610,	"color": ${ "def.color1" } },   //    0 - 609  - bad		(20% of players)
      { "value": 850,	"color": ${ "def.color2" } },   //  610 - 849  - below average	(better then 20% of players)
      { "value": 1145,	"color": ${ "def.color3" } },   //  850 - 1144 - normal		(better then 60% of players)
      { "value": 1475,	"color": ${ "def.color4" } },   // 1145 - 1474 - good		(better then 90% of players)
      { "value": 1775,	"color": ${ "def.color5" } },   // 1475 - 1774 - very good	(better then 99% of players)
      { "value": 9999,	"color": ${ "def.color6" } }    // 1775 - *    - skillful     	(better then 99.9% of players)
    ],
    // Dynamic color by WN6 rating
    // Динамический цвет по рейтингу WN6
    "wn6": [
      { "value": 410,	"color": ${ "def.color1" } },   //    0 - 409  - bad		(20% of players)
      { "value": 795,	"color": ${ "def.color2" } },   //  410 - 794  - below average	(better then 20% of players)
      { "value": 1185,	"color": ${ "def.color3" } },   //  795 - 1184 - normal		(better then 60% of players)
      { "value": 1585,	"color": ${ "def.color4" } },   // 1185 - 1584 - good		(better then 90% of players)
      { "value": 1925,	"color": ${ "def.color5" } },   // 1585 - 1924 - very good	(better then 99% of players)
      { "value": 9999,	"color": ${ "def.color6" } }    // 1925 - *    - skillful     	(better then 99.9% of players)
    ],
    // Dynamic color by WN8 rating
    // Динамический цвет по рейтингу WN8
    "wn8": [
      { "value": 355,	"color": ${ "def.color1" } },   // bad		  (20% of players)
      { "value": 820,	"color": ${ "def.color2" } },   // below average  (better then 20% of players)
      { "value": 1370,	"color": ${ "def.color3" } },   // normal	  (better then 60% of players)
      { "value": 2020,	"color": ${ "def.color4" } },   // good		  (better then 90% of players)
      { "value": 2620,	"color": ${ "def.color5" } },   // very good	  (better then 99% of players)
      { "value": 9999,	"color": ${ "def.color6" } }    // skillful	  (better then 99.9% of players)
    ],
    // Dynamic color by WG rating
    // Динамический цвет по рейтингу WG
    "wgr": [
      { "value": 2020,  "color": ${ "def.color1" } },  // very bad   (20% of players)
      { "value": 4185,  "color": ${ "def.color2" } },  // bad        (better then 20% of players)
      { "value": 6340,  "color": ${ "def.color3" } },  // normal     (better then 60% of players)
      { "value": 8525,  "color": ${ "def.color4" } },  // good       (better then 90% of players)
      { "value": 9930,  "color": ${ "def.color5" } },  // very good  (better then 99% of players)
      { "value": 99999, "color": ${ "def.color6" } }   // unique     (better then 99.9% of players)
    ],
    // Dynamic color by TEFF (E) rating.
    // Динамический цвет по рейтингу TEFF (E).
    "e": [
      { "value": 3,	"color": ${ "def.color1" } },   // 1-2- bad			/ владеет танком плохо
      { "value": 6,	"color": ${ "def.color2" } },   // 3-5- below average		/ владеет танком ниже среднего
      { "value": 7,	"color": ${ "def.color3" } },   //   6- normal			/ владеет танком средне
      { "value": 8,	"color": ${ "def.color4" } },   //   7- good			/ владеет танком хорошо
      { "value": 9,	"color": ${ "def.color5" } },   //   8- very good		/ владеет танком очень хорошо
      { "value": 20,	"color": ${ "def.color6" } }    //   9-10- skillful		/ владеет танком мастерски
    ],
    // Dynamic color by win percent.
    // Динамический цвет по проценту побед.
    "rating": [
      { "value": 46.5,	"color": ${ "def.color1" } },   //    0 - 46.5  - bad		(20% of players)
      { "value": 48.5,	"color": ${ "def.color2" } },   // 46.5 - 48.5  - below average	(better then 20% of players)
      { "value": 51.5,	"color": ${ "def.color3" } },   // 48.5 - 51.5  - normal	(better then 60% of players)
      { "value": 56.5,	"color": ${ "def.color4" } },   // 51.5 - 56.5  - good		(better then 90% of players)
      { "value": 64.5,	"color": ${ "def.color5" } },   // 56.5 - 64.5  - very good	(better then 99% of players)
      { "value": 101,	"color": ${ "def.color6" } }    // 64.5 - 100   - skillful	(better then 99.9% of players)
    ],
    // Dynamic color by kilo-battles.
    // Динамический цвет по количеству кило-боев.
    "kb": [
      { "value": 1.5,	"color": ${ "def.color1" } },    //    0 - 1.5
      { "value": 4.5,	"color": ${ "def.color2" } },    //  1.5 - 4.5
      { "value": 8.5,	"color": ${ "def.color3" } },    //  4.5 - 8.5
      { "value": 13.5,	"color": ${ "def.color4" } },	 //  8.5 - 13.5
      { "value": 19.5,	"color": ${ "def.color5" } },	 // 13.5 - 19.5
      { "value": 999,	"color": ${ "def.color6" } }	 // 19.5 - *
    ],
    // Dynamic color by average level of player tanks.
    // Динамический цвет по среднему уровню танков игрока.
    "avglvl": [
      { "value": 4.5,  "color": ${ "def.color1" } },
      { "value": 7.5,  "color": ${ "def.color0" } },
      { "value": 11,   "color": ${ "def.color6" } }
    ],
    // Dynamic color by battles on current tank.
    // Динамический цвет по количеству боев на текущем танке.
    "t_battles": [
      { "value": 150,	"color": ${ "def.color1" } },    //    0h - 1.5h
      { "value": 350,	"color": ${ "def.color2" } },    //  1.5h - 3.5h
      { "value": 650,	"color": ${ "def.color3" } },    //  3.5h - 6.5h
      { "value": 1050,	"color": ${ "def.color4" } },    //  6.5h - 10.5h
      { "value": 1750,	"color": ${ "def.color5" } },    // 10.5h - 17.5h
      { "value": 99999,	"color": ${ "def.color6" } }     // 17.5h - *
    ],
    // Dynamic color by average damage on current tank.
    // Динамический цвет по среднему урону за бой на текущем танке.
    "tdb": [
      { "value": 500,	"color": ${ "def.color1" } },
      { "value": 750,	"color": ${ "def.color2" } },
      { "value": 1000,	"color": ${ "def.color3" } },
      { "value": 1800,	"color": ${ "def.color4" } },
      { "value": 2500,	"color": ${ "def.color5" } },
      { "value": 9999,	"color": ${ "def.color6" } }
    ],
    // Dynamic color by average damage efficiency on current tank.
    // Динамический цвет по эффективности урона за бой на текущем танке.
    "tdv": [
      { "value": 0.6,	"color": ${ "def.color1" } },
      { "value": 0.8,	"color": ${ "def.color2" } },
      { "value": 1.0,	"color": ${ "def.color3" } },
      { "value": 1.3,	"color": ${ "def.color4" } },
      { "value": 2.0,	"color": ${ "def.color5" } },
      { "value": 15,	"color": ${ "def.color6" } }
    ],
    // Dynamic color by average frags per battle on current tank.
    // Динамический цвет по среднему количеству фрагов за бой на текущем танке.
    "tfb": [
      { "value": 0.6,	"color": ${ "def.color1" } },
      { "value": 0.8,	"color": ${ "def.color2" } },
      { "value": 1.0,	"color": ${ "def.color3" } },
      { "value": 1.3,	"color": ${ "def.color4" } },
      { "value": 2.0,	"color": ${ "def.color5" } },
      { "value": 15,	"color": ${ "def.color6" } }
    ],
    // Dynamic color by number of spotted enemies per battle on current tank.
    // Динамический цвет по среднему количеству засвеченных врагов за бой на текущем танке.
    "tsb": [
      { "value": 0.6,	"color": ${ "def.color1" } },
      { "value": 0.8,	"color": ${ "def.color2" } },
      { "value": 1.0,	"color": ${ "def.color3" } },
      { "value": 1.3,	"color": ${ "def.color4" } },
      { "value": 2.0,	"color": ${ "def.color5" } },
      { "value": 15,	"color": ${ "def.color6" } }
    ],
    // Dynamic color by WN8 effective damage
    // Динамический цвет по эффективному урону по WN8
    "wn8effd": [
      { "value": 0.6,	"color": ${ "def.color1" } },
      { "value": 0.8,	"color": ${ "def.color2" } },
      { "value": 1.0,	"color": ${ "def.color3" } },
      { "value": 1.3,	"color": ${ "def.color4" } },
      { "value": 2.0,	"color": ${ "def.color5" } },
      { "value": 15,	"color": ${ "def.color6" } }
    ],
    // Dynamic color by damage rating (percents for marks on gun)
    // Динамический цвет по рейтингу урона (процент для отметок на стволе)
    "damageRating": [
      { "value": 65,    "color": ${ "def.color1" } },
      { "value": 85,    "color": ${ "def.color3" } },
      { "value": 95,    "color": ${ "def.color4" } },
      { "value": 101,   "color": ${ "def.color6" } }
    ],
    // Dynamic color by hit ratio (percents of hits)
    // Динамический цвет по проценту попаданий
    "hitsRatio": [
      { "value": 47.5,    "color": ${ "def.color1" } },
      { "value": 60.5,    "color": ${ "def.color2" } },
      { "value": 68.5,    "color": ${ "def.color3" } },
      { "value": 74.5,    "color": ${ "def.color4" } },
      { "value": 78.5,  "color": ${ "def.color5" } },
      { "value": 101,   "color": ${ "def.color6" } }
    ]
  }
}