﻿/**
 * Parameters for tank carousel
 * Параметры карусели танков
 */
{
"def": {
    // Text fields shadow definition.
    // Шаблон тени текстовых полей.
	"textFieldShadow": { "color": "0x000000", "alpha": 0.8, "blur": 2, "strength": 2, "distance": 0, "angle": 0 }
  },
  "carousel": {
    // false - Disable customizable carousel.
    // false - Отключить настраиваемую карусель.
    "enabled": true,
    // Scale of carousel cells.
    // Масштаб ячеек карусели.
    "zoom": 1,
    // Number of rows at carousel.
    // Количество рядов карусели.
    "rows": 2,
    // Spacing between carousel cells.
    // Отступ между ячейками карусели.
    "padding": {
        "horizontal": 5,   // по горизонтали
        "vertical": 5      // по вертикали
    },
    // true - show filters even if all tanks fit on the screen.
    // true - показывать фильтры даже если все танки помещаются на экране.
    "alwaysShowFilters": true,
    // true - hide cell "Buy tank".
    // true - скрыть ячейку "Купить танк".
    "hideBuyTank": false,
    // true - hide cell "Buy slot".
    // true - скрыть ячейку "Купить слот".
    "hideBuySlot": false,
    // Visibility filters.
    // Видимость фильтров.
    "filters": {
      // false - hide filter.
      // false - скрыть фильтр.
      "nation":   { "enabled": true },  // nation           / страна
      "type":     { "enabled": true },  // vehicle class    / тип техники
      "level":    { "enabled": true },  // vehicle level    / уровень техники
      "favorite": { "enabled": true },  // favorite tanks   / основные танки
      "prefs":    { "enabled": true }   // other filters    / другие фильтры
    },
    // Standard cell elements.
    // Стандартные элементы ячеек.
    "fields": {
      // "visible"  - the visibility of the element / видимость элемента
      // "dx"       - horizontal shift              / смещение по горизонтали
      // "dy"       - vertical shift                / смещение по вертикали
      // "alpha"    - transparency                  / прозрачность
      // "scale"    - scale                         / масштаб
      //
      // Vehicle class icon.
      // Иконка типа техники.
      "tankType": { "visible": true,  "dx": 0, "dy": 0, "alpha": 100, "scale": 1 },
      // Vehicle level.
      // Уровень техники
      "level":    { "visible": false, "dx": 0, "dy": 0, "alpha": 100, "scale": 1 },
      // todo: english description
      // Иконка не сбитого кратного опыта за первую победу в день.
      "multiXp":  { "visible": true,  "dx": 0, "dy": 0, "alpha": 100, "scale": 1 },
      // todo: english description
      // Иконка не сбитого опыта за первую победу в день.
      "xp":       { "visible": true,  "dx": 0, "dy": 0, "alpha": 100, "scale": 1 },
      // Vehicle name.
      // Название танка.
      "tankName": { "visible": false, "dx": 0, "dy": 0, "alpha": 100, "scale": 1 }
    },
    // Extra cell fields (see playersPanel.xc).
    // Дополнительные поля ячеек (см. playersPanel.xc).
    "extraFields": [
	{ "x": -1, "y": -2, "w": 162, "h": 2, "bgColor": "0x60FF00", "alpha": "{{v.selected?30|0}}" },
	{ "x": -1, "y": 100, "w": 162, "h": 2, "bgColor": "0x60FF00", "alpha": "{{v.selected?30|0}}" },
	{ "x": -2, "y": 0, "w": 2, "h": 100, "bgColor": "0x60FF00", "alpha": "{{v.selected?30|0}}" },
	{ "x": 160, "y": 0, "w": 2, "h": 100, "bgColor": "0x60FF00", "alpha": "{{v.selected?30|0}}" },

	{ "x": -1, "y": -2, "w": 162, "h": "{{v.selected?0|2}}", "bgColor": "{{v.premium?#FF884C|#FFDD99}}", "alpha": "{{v.premium?20|10}}" },
	{ "x": -1, "y": 100, "w": 162, "h": "{{v.selected?0|2}}", "bgColor": "{{v.premium?#FF884C|#FFDD99}}", "alpha": "{{v.premium?20|10}}" },
	{ "x": -2, "y": 0, "w": 2, "h": "{{v.selected?0|100}}", "bgColor": "{{v.premium?#FF884C|#FFDD99}}", "alpha": "{{v.premium?20|10}}" },
	{ "x": 160, "y": 0, "w": 2, "h": "{{v.selected?0|100}}", "bgColor": "{{v.premium?#FF884C|#FFDD99}}", "alpha": "{{v.premium?20|10}}" },

        { "x": 0, "y": 0, "alpha": 25, "src": "xvm://configs/demon2597/img/{{v.premium}}Slot.png" },

	{ "x": 70, "y": 0, "w": 100, "h": 17, "rotation": 140, "bgColor": "0xFF884C", "alpha": "{{v.premium?22|0}}" },
	{ "x": 45, "y": 0, "w": 100, "h": 1, "rotation": 140, "bgColor": "0xFC3700", "alpha": "{{v.premium?22|0}}" },
	{ "x": 70, "y": 0, "w": 100, "h": 1, "rotation": 140, "bgColor": "0xFC3700", "alpha": "{{v.premium?22|0}}" },

        { "x": 135, "y": 57, "w": 25, "h": 25, "src": "img://gui/maps/icons/library/proficiency/class_icons_{{v.mastery}}.png" },
        { "x": 4, "y": 20, "src": "xvm://configs/demon2597/img/mog{{v.marksOnGun|x}}.png" },
        { "x": 11, "y": "{{v.marksOnGun?18|17}}", "align": "center",
          "format": "<b><font face='$FieldFont' size='9' color='#C8C8B5'>{{v.marksOnGun|x}}</font></b>",
          "shadow": ${ "def.textFieldShadow" }
        },
        { "x": 21, "y": 0,
          "format": "<b><font face='$FieldFont' size='12' color='#C8C8B5'><font face='Arial'>{{v.rlevel}}</font>  {{v.battletiermin}}-{{v.battletiermax}}</font></b>",
          "shadow": ${ "def.textFieldShadow" }
        },
        { "x": 21, "y": 15,
          "format": "<b><font face='$FieldFont' size='12' color='{{v.c_winrate}}'>{{v.winrate%2d~%}}</font></b>",
          "shadow": ${ "def.textFieldShadow" }
        },
        { "x": 158, "y": 77, "align": "right", "alpha": "{{v.premium?100|0}}",
          "format": "<font face='$FieldFont' size='15' color='#FEA659'>{{v.name}}</font>",
          "shadow": { "color": "0xFC3700", "alpha": 1, "blur": 10, "strength": 2, "distance": 0, "angle": 0 }
        },
        { "x": 158, "y": 77, "align": "right", "alpha": "{{v.premium?0|100}}",
          "format": "<font face='$FieldFont' size='15' color='#C8C8B5'>{{v.name}}</font>",
          "shadow": { "color": "0x73734C", "alpha": 0.8, "blur": 6, "strength": 2, "distance": 0, "angle": 0 }
        }
    ]
  }
}
