﻿/**
 * Options for dynamic transparency. Values ​​from smallest to largest.
 * Настройки динамической прозрачности. Значения от меньшего к большему.
 */
{
  "alpha": {
    // Dynamic transparency by spotted status
    // Динамическая прозрачность по статусу засвета
    "spotted": {
      "neverSeen":      100,
      "lost":           100,
      "revealed":       100,
      "dead":           50,
      "neverSeen_arty": 100,
      "lost_arty":      100,
      "revealed_arty":  100,
      "dead_arty":      50
    },
    // Dynamic transparency by remaining health.
    // Динамическая прозрачность по оставшемуся здоровью. 
    "hp": [
      { "value": 200,	"alpha": 100 },   // Прозрачность для значений менее 200
      { "value": 400,	"alpha": 100 },   // Прозрачность для значений менее 400
      { "value": 1000,	"alpha": 100 },   // Прозрачность для значений менее 1000
      { "value": 9999,	"alpha": 100 }    // Прозрачность для остальных значений
    ],
    // Dynamic transparency by percentage of remaining health.
    // Динамическая прозрачность по проценту оставшегося здоровья.
    "hp_ratio": [
      { "value": 25,	"alpha": 100 },   // Прозрачность для значений менее 25 процентов
      { "value": 101,	"alpha": 0 }      // Прозрачность для остальных значений
    ],
    // Dynamic transparency for XVM Scale.
    // Динамическая прозрачность по шкале XVM.
    "x": [
      { "value": 16.5,  "alpha": 100 },   // 00   - 16.5 - bad			(20% of players)
      { "value": 33.5,  "alpha": 100 },   // 16.5 - 33.5 - below average	(better then 20% of players)
      { "value": 52.5,  "alpha": 100 },   // 33.5 - 52.5 - normal			(better then 60% of players)
      { "value": 75.5,  "alpha": 100 },   // 52.5 - 75.5 - good			(better then 90% of players)
      { "value": 92.5,  "alpha": 100 },   // 75.5 - 92.5 - very good		(better then 99% of players)
      { "value": 999,	"alpha": 100 }    // 92.5 - XX   - skillful			(better then 99.9% of players)
    ],
    // Dynamic transparency by efficiency.
    // Динамическая прозрачность по эффективности.
    "eff": [
      { "value": 610,	"alpha": 100 },   //    0 - 609  - bad
      { "value": 850,	"alpha": 100 },   //  610 - 849  - below average
      { "value": 1145,	"alpha": 100 },   //  850 - 1144 - normal
      { "value": 1475,	"alpha": 100 },   // 1145 - 1474 - good
      { "value": 1775,	"alpha": 100 },   // 1475 - 1774 - very good
      { "value": 9999,	"alpha": 100 }    // 1775 - *    - skillful
    ],
    // Dynamic transparency by WN6 rating.
    // Динамическая прозрачность по рейтингу WN6.
    "wn6": [
      { "value": 410,	"alpha": 100 },   //    0 - 409  - bad
      { "value": 795,	"alpha": 100 },   //  410 - 794  - below average
      { "value": 1185,	"alpha": 100 },   //  795 - 1184 - normal
      { "value": 1585,	"alpha": 100 },   // 1185 - 1584 - good
      { "value": 1925,	"alpha": 100 },   // 1585 - 1924 - very good
      { "value": 9999,	"alpha": 100 }    // 1925 - *    - skillful
    ],
    // Dynamic transparency by WN8 rating.
    // Динамическая прозрачность по рейтингу WN8.
    "wn8": [
      { "value": 355,	"alpha": 100 },   // bad
      { "value": 820,	"alpha": 100 },   // below average
      { "value": 1370,	"alpha": 100 },   // normal
      { "value": 2020,	"alpha": 100 },   // good
      { "value": 2620,	"alpha": 100 },   // very good
      { "value": 9999,	"alpha": 100 }    // skillful
    ],
    // Dynamic transparency by WG rating
    // Динамическая прозрачность по рейтингу WG
    "wgr": [
      { "value": 2020,  "alpha": 100 },
      { "value": 4185,  "alpha": 100 },
      { "value": 6340,  "alpha": 100 },
      { "value": 8525,  "alpha": 100 },
      { "value": 9930,  "alpha": 100 },
      { "value": 99999, "alpha": 100 }
    ],
    // Dynamic transparency by TEFF (E) rating.
    // Динамическая прозрачность по рейтингу TEFF (E).
    "e": [
      { "value": 3,	"alpha": 100 },    // 1-2- bad		/ владеет танком плохо
      { "value": 6,	"alpha": 100 },    // 3-5- below average	/ владеет танком ниже среднего
      { "value": 7,	"alpha": 100 },    // 6- normal		/ владеет танком средне
      { "value": 8,	"alpha": 100 },    // 7- good			/ владеет танком хорошо
      { "value": 9,	"alpha": 100 },    // 8- very good	/ владеет танком очень хорошо
      { "value": 20,	"alpha": 100 }     // 9-10- skillful		/ владеет танком мастерски
    ],
    // Dynamic transparency by win percent.
    // Динамическая прозрачность по проценту побед.
    "rating": [
      { "value": 47,	"alpha": 100 },	   //  0   - 46.5  - bad
      { "value": 49,	"alpha": 100 },	   // 46.5 - 48.5  - below average
      { "value": 52,	"alpha": 100 },	   // 48.5 - 51.5  - normal
      { "value": 57,	"alpha": 100 },	   // 51.5 - 56.5  - good
      { "value": 65,	"alpha": 100 },	   // 56.5 - 64.5  - very good
      { "value": 101,	"alpha": 100 }	   // 63.5 - 100   - skillful
    ],
    // Dynamic transparency by kilo-battles.
    // Динамическая прозрачность по количеству кило-боев.
    "kb": [
      { "value": 4.5,	"alpha": 0 },      //  0 - 4.5
      { "value": 999,	"alpha": 100 }     // 4.5 - *
    ],
    // Dynamic transparency by average level of player tanks.
    // Динамическая прозрачность по среднему уровню танков игрока.
    "avglvl": [
      { "value": 2,	"alpha": 100 },
      { "value": 3,	"alpha": 100 },
      { "value": 5,	"alpha": 100 },
      { "value": 7,	"alpha": 100 },
      { "value": 9,	"alpha": 100 },
      { "value": 11,	"alpha": 100 }
    ],
    // Dynamic transparency by battles on current tank.
    // Динамическая прозрачность по количеству боев на текущем танке.
    "t_battles": [
      { "value": 150,	"alpha": 0 },    //  0h - 1.5h
      { "value": 99999,	"alpha": 100 }   // 1.5h - *
    ],
    // Dynamic transparency by average damage on current tank.
    // Динамическая прозрачность по среднему урону за бой на текущем танке.
    "tdb": [
      { "value": 500,	"alpha": 100 },
      { "value": 750,	"alpha": 100 },
      { "value": 1000,	"alpha": 100 },
      { "value": 1800,	"alpha": 100 },
      { "value": 2500,	"alpha": 100 },
      { "value": 9999,	"alpha": 100 }
    ],
    // Dynamic transparency by average damage efficiency on current tank.
    // Динамическая прозрачность по эффективности урона за бой на текущем танке.
    "tdv": [
      { "value": 0.6,	"alpha": 100 },
      { "value": 0.8,	"alpha": 100 },
      { "value": 1.0,	"alpha": 100 },
      { "value": 1.3,	"alpha": 100 },
      { "value": 2.0,	"alpha": 100 },
      { "value": 15,	"alpha": 100 }
    ],
    // Dynamic transparency by average frags per battle on current tank.
    // Динамическая прозрачность по среднему количеству фрагов за бой на текущем танке.
    "tfb": [
      { "value": 0.6,	"alpha": 100 },
      { "value": 0.8,	"alpha": 100 },
      { "value": 1.0,	"alpha": 100 },
      { "value": 1.3,	"alpha": 100 },
      { "value": 2.0,	"alpha": 100 },
      { "value": 15,	"alpha": 100 }
    ],
    // Dynamic transparency by number of spotted enemies per battle on current tank.
    // Динамическая прозрачность по среднему количеству засвеченных врагов за бой на текущем танке.
    "tsb": [
      { "value": 0.6,	"alpha": 100 },
      { "value": 0.8,	"alpha": 100 },
      { "value": 1.0,	"alpha": 100 },
      { "value": 1.3,	"alpha": 100 },
      { "value": 2.0,	"alpha": 100 },
      { "value": 15,	"alpha": 100 }
    ]
  }
}